/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.items;

import java.util.UUID;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;

public class ShogunArmorItem
extends GeoArmorItem
implements IAnimatable {
    public static final UUID SPEED_MODIFIER_RUNNING_UUID = UUID.fromString("05cd373b-0ff1-4ded-8630-b380232ed7b1");
    public static final AttributeModifier SPEED_MODIFIER_RUN = new AttributeModifier(SPEED_MODIFIER_RUNNING_UUID, "Running speed increase", 0.1, AttributeModifier.Operation.ADDITION);
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ShogunArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        LivingEntity livingEntity = (LivingEntity)event.getExtraDataOfType(LivingEntity.class).get(0);
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if ((double)(groundSpeed * 20.0f) <= 0.35) {
            event.getController().setAnimationSpeed((double)Math.max(Math.min(groundSpeed * 20.0f, 1.3f), 0.75f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        } else if ((double)(groundSpeed * 20.0f) > 0.35 && (double)(groundSpeed * 20.0f) <= 2.1) {
            event.getController().setAnimationSpeed((double)Math.max(Math.min(groundSpeed * 20.0f, 1.3f), 0.75f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimationSpeed((double)Math.max(Math.min(groundSpeed * 20.0f, 1.3f), 0.75f));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("run", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }
}

